% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pearson.beta.R
\name{pearson.beta}
\alias{pearson.beta}
\title{Calculate Pearson beta}
\usage{
pearson.beta(
  y,
  x,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  CI.width = 0.95,
  max.exact.cases = 10,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.CI = FALSE,
  do.mc = FALSE
)
}
\arguments{
\item{y}{Numeric vector of same length as x}

\item{x}{Numeric vector of same length as y}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{10})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{FALSE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}
}
\value{
An ANSMstat object with the results from applying the function
}
\description{
\code{pearson.beta()} calculates the Pearson beta and is used in chapter 11 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 11.2 from "Applied Nonparametric Statistical Methods" (5th edition)
pearson.beta(ch11$reportedtime, ch11$parentlimit, H0 = 1)
pearson.beta(ch11$reportedtime[1:6], ch11$parentlimit[1:6], H0 = 1)

}
