% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_property.R
\name{av_property}
\alias{av_property}
\alias{av_name}
\alias{av_cid}
\alias{av_synonyms}
\alias{av_tradenames}
\alias{av_group}
\alias{av_atc}
\alias{av_loinc}
\alias{av_ddd}
\alias{av_ddd_units}
\alias{av_info}
\alias{av_url}
\title{Get Properties of an Antiviral Drug}
\usage{
av_name(x, language = get_AMR_locale(), tolower = FALSE, ...)

av_cid(x, ...)

av_synonyms(x, ...)

av_tradenames(x, ...)

av_group(x, language = get_AMR_locale(), ...)

av_atc(x, ...)

av_loinc(x, ...)

av_ddd(x, administration = "oral", ...)

av_ddd_units(x, administration = "oral", ...)

av_info(x, language = get_AMR_locale(), ...)

av_url(x, open = FALSE, ...)

av_property(x, property = "name", language = get_AMR_locale(), ...)
}
\arguments{
\item{x}{Any (vector of) text that can be coerced to a valid antiviral drug code with \code{\link[=as.av]{as.av()}}.}

\item{language}{Language of the returned text - the default is system language (see \code{\link[=get_AMR_locale]{get_AMR_locale()}}) and can also be set with the package option \code{\link[=AMR-options]{AMR_locale}}. Use \code{language = NULL} or \code{language = ""} to prevent translation.}

\item{tolower}{A \link{logical} to indicate whether the first \link{character} of every output should be transformed to a lower case \link{character}.}

\item{...}{Other arguments passed on to \code{\link[=as.av]{as.av()}}.}

\item{administration}{Way of administration, either \code{"oral"} or \code{"iv"}.}

\item{open}{Browse the URL using \code{\link[utils:browseURL]{utils::browseURL()}}.}

\item{property}{One of the column names of one of the \link{antivirals} data set: \code{vector_or(colnames(antivirals), sort = FALSE)}.}
}
\value{
\itemize{
\item An \link{integer} in case of \code{\link[=av_cid]{av_cid()}}
\item A named \link{list} in case of \code{\link[=av_info]{av_info()}} and multiple \code{\link[=av_atc]{av_atc()}}/\code{\link[=av_synonyms]{av_synonyms()}}/\code{\link[=av_tradenames]{av_tradenames()}}
\item A \link{double} in case of \code{\link[=av_ddd]{av_ddd()}}
\item A \link{character} in all other cases
}
}
\description{
Use these functions to return a specific property of an antiviral drug from the \link{antivirals} data set. All input values will be evaluated internally with \code{\link[=as.av]{as.av()}}.
}
\details{
All output \link[=translate]{will be translated} where possible.

The function \code{\link[=av_url]{av_url()}} will return the direct URL to the official WHO website. A warning will be returned if the required ATC code is not available.
}
\section{Source}{

World Health Organization (WHO) Collaborating Centre for Drug Statistics Methodology: \url{https://atcddd.fhi.no/atc_ddd_index/}

European Commission Public Health PHARMACEUTICALS - COMMUNITY REGISTER: \url{https://ec.europa.eu/health/documents/community-register/html/reg_hum_atc.htm}
}

\section{Download Our Reference Data}{

All reference data sets in the AMR package - including information on microorganisms, antimicrobials, and clinical breakpoints - are freely available for download in multiple formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, and Stata.

For maximum compatibility, we also provide machine-readable, tab-separated plain text files suitable for use in any software, including laboratory information systems.

Visit \href{https://amr-for-r.org/articles/datasets.html}{our website for direct download links}, or explore the actual files in \href{https://github.com/msberends/AMR/tree/main/data-raw/datasets}{our GitHub repository}.
}

\examples{
# all properties:
av_name("ACI")
av_atc("ACI")
av_cid("ACI")
av_synonyms("ACI")
av_tradenames("ACI")
av_group("ACI")
av_url("ACI")

# lowercase transformation
av_name(x = c("ACI", "VALA"))
av_name(x = c("ACI", "VALA"), tolower = TRUE)

# defined daily doses (DDD)
av_ddd("ACI", "oral")
av_ddd_units("ACI", "oral")
av_ddd("ACI", "iv")
av_ddd_units("ACI", "iv")

av_info("ACI") # all properties as a list

# all av_* functions use as.av() internally, so you can go from 'any' to 'any':
av_atc("ACI")
av_group("J05AB01")
av_loinc("abacavir")
av_name("29113-8")
av_name(135398513)
av_name("J05AB01")
}
\seealso{
\link{antivirals}
}
