% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age_groups}
\alias{age_groups}
\title{Split ages into age groups}
\usage{
age_groups(x, split_at = c(12, 25, 55, 75), na.rm = FALSE)
}
\arguments{
\item{x}{age, e.g. calculated with \code{\link[=age]{age()}}}

\item{split_at}{values to split \code{x} at, defaults to age groups 0-11, 12-24, 25-54, 55-74 and 75+. See Details.}

\item{na.rm}{a logical to indicate whether missing values should be removed}
}
\value{
Ordered \code{\link{factor}}
}
\description{
Split ages into age groups defined by the \code{split} parameter. This allows for easier demographic (antimicrobial resistance) analysis.
}
\details{
To split ages, the input can be:
\itemize{
\item A numeric vector. A vector of e.g. \code{c(10, 20)} will split on 0-9, 10-19 and 20+. A value of only \code{50} will split on 0-49 and 50+.
The default is to split on young children (0-11), youth (12-24), young adults (25-54), middle-aged adults (55-74) and elderly (75+).
\item A character:
\itemize{
\item \code{"children"} or \code{"kids"}, equivalent of: \code{c(0, 1, 2, 4, 6, 13, 18)}. This will split on 0, 1, 2-3, 4-5, 6-12, 13-17 and 18+.
\item \code{"elderly"} or \code{"seniors"}, equivalent of: \code{c(65, 75, 85)}. This will split on 0-64, 65-74, 75-84, 85+.
\item \code{"fives"}, equivalent of: \code{1:20 * 5}. This will split on 0-4, 5-9, 10-14, ..., 90-94, 95-99, 100+.
\item \code{"tens"}, equivalent of: \code{1:10 * 10}. This will split on 0-9, 10-19, 20-29, ... 80-89, 90-99, 100+.
}
}
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
ages <- c(3, 8, 16, 54, 31, 76, 101, 43, 21)

# split into 0-49 and 50+
age_groups(ages, 50)

# split into 0-19, 20-49 and 50+
age_groups(ages, c(20, 50))

# split into groups of ten years
age_groups(ages, 1:10 * 10)
age_groups(ages, split_at = "tens")

# split into groups of five years
age_groups(ages, 1:20 * 5)
age_groups(ages, split_at = "fives")

# split specifically for children
age_groups(ages, "children")
# same:
age_groups(ages, c(1, 2, 4, 6, 13, 17))

\dontrun{
# resistance of ciprofloxacine per age group
library(dplyr)
example_isolates \%>\%
  filter_first_isolate() \%>\%
  filter(mo == as.mo("E. coli")) \%>\%
  group_by(age_group = age_groups(age)) \%>\%
  select(age_group, CIP) \%>\%
  ggplot_rsi(x = "age_group")
}
}
\seealso{
To determine ages, based on one or more reference dates, use the \code{\link[=age]{age()}} function.
}
