% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{join}
\alias{join}
\alias{inner_join_bactlist}
\alias{inner_join}
\alias{left_join_bactlist}
\alias{right_join_bactlist}
\alias{full_join_bactlist}
\alias{semi_join_bactlist}
\alias{anti_join_bactlist}
\title{Join a table with \code{bactlist}}
\usage{
inner_join_bactlist(x, by = "bactid", ...)

left_join_bactlist(x, by = "bactid", ...)

right_join_bactlist(x, by = "bactid", ...)

full_join_bactlist(x, by = "bactid", ...)

semi_join_bactlist(x, by = "bactid", ...)

anti_join_bactlist(x, by = "bactid", ...)
}
\arguments{
\item{x}{existing table to join}

\item{by}{a variable to join by - could be a column name of \code{x} with values that exist in \code{bactlist$bactid} (like \code{by = "bacteria_id"}), or another column in \code{\link{bactlist}} (but then it should be named, like \code{by = c("my_genus_species" = "fullname")})}

\item{...}{other parameters to pass on to \code{dplyr::\link[dplyr]{join}}.}
}
\description{
Join the list of microorganisms \code{\link{bactlist}} easily to an existing table.
}
\details{
As opposed to the \code{\link[dplyr]{join}} functions of \code{dplyr}, at default existing columns will get a suffix \code{"2"} and the newly joined columns will not get a suffix. See \code{\link[dplyr]{join}} for more information.
}
\examples{
df <- data.frame(date = seq(from = as.Date("2018-01-01"),
                            to = as.Date("2018-01-07"),
                            by = 1),
                 bacteria_id = c("STAAUR", "STAAUR", "STAAUR", "STAAUR",
                                 "ESCCOL", "ESCCOL", "ESCCOL"),
                 stringsAsFactors = FALSE)
                 
colnames(df)
df2 <- left_join_bactlist(df, "bacteria_id")
colnames(df2)
}
