\name{chapter_12_table_21}
\alias{chapter_12_table_21}
\docType{data}
\title{
The data used in Chapter 12 Table 21.
}
\description{
The data used in Chapter 12 Table 21.
}
\usage{data("chapter_12_table_21")}
\format{
  A data frame with 18 observations on the following 5 variables.
  \describe{
    \item{\code{dv}}{dependent variable; the number of aggressive behaviors in a time period}
    \item{\code{subject}}{one pair of monkeys (6 total)}
    \item{\code{time}}{time period}
    \item{\code{cond}}{treatment condition}
    \item{\code{square}}{a numeric vector}
  }
}
\details{Suppose that we are interested in comparing the effects of three drugs (A, B, and C) on aggressiveness on monkeys. To control for possible order effects, we use a Latin square design. Specifically, we suppose that six subjects are available (as we discussed in Chapter 11, a subject is actually a pair of monkeys in this design). Following the design principles outlined at the end of Chapter 11, we use a replicated Latin square design with two randomly consituted squares. Subjects are then randomly assigned to rows of the squares. The dependent measure can be thought of as the number of aggressive behvaiors engaged in during a fixed time period. Notice that each sore is a function of three possible influences: subject, time period, and treatment condition (where here is drug, with three levels, either A, B, or C).

To summarize, the data in Table 12.21 consists of hypothetical aggressiveness scores for 6 monkeys who have been exposed to three types of drugs (A, B, and C). In order to control for potential order effects, a Latin square design is utilized. In particular, two randomly constituted squares are formed with three monkeys randomly assigned to each square and also randomly assigned to the particular row of the square that assigns the order that they are exposed to treatment
 
The hypothesis of primary interest is whether the drugs differ in their effectiveness in controlling aggression in the monkeys. Thus, the test of the condition main effect is of primary interest. The current SPSS syntax reproduces the results for test of the condition main effect shown on page 615}
%%  ~~ If necessary, more details than the __description__ above ~~
%}
\source{
Maxwell, S. E., Delaney, H. D., & Kelley, K. (forthcoming). Designing experiments and 
analyzing data: {A} model comparison perspective. Taylor & Francis.}
\references{
Maxwell, S. E., Delaney, H. D., & Kelley, K. (forthcoming). Designing experiments and 
analyzing data: {A} model comparison perspective. Taylor & Francis.}
\examples{
data(chapter_12_table_21)
}
\keyword{datasets}
