% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/Getters.R
\docType{methods}
\name{getMaxCorner}
\alias{getMaxCorner}
\alias{getMaxCorner,VoxelSpace-method}
\title{Gets the x, y, z coordinates of the voxel space top right corner.}
\usage{
getMaxCorner(vxsp)

\S4method{getMaxCorner}{VoxelSpace}(vxsp)
}
\arguments{
\item{vxsp}{the \code{\link{VoxelSpace-class}} object.}
}
\value{
the x, y, z coordinates of the voxel space top right corner, as a
numerical vector.
}
\description{
Gets the x, y, z coordinates of the voxel space top right
corner.
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# retrieve 'max_corner' parameter
getMaxCorner(vxsp)
}
