% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMAPVoxGenerics.R, R/AMAPVoxGetters.R
\docType{methods}
\name{getMinCorner}
\alias{getMinCorner}
\alias{getMinCorner,VoxelSpace-method}
\title{Gets the x, y, z coordinates of the voxel space bottom left corner.}
\usage{
getMinCorner(voxelSpace)

\S4method{getMinCorner}{VoxelSpace}(voxelSpace)
}
\arguments{
\item{voxelSpace}{the \code{\link{VoxelSpace-class}} object.}
}
\value{
the x, y, z coordinates of the voxel space bottom left corner, as a
numerical vector.
}
\description{
Gets the x, y, z coordinates of the voxel space bottom left
corner.
}
\examples{
# load a voxel file
vox <- readVoxelSpace(system.file("extdata", "als_sample.vox", package = "AMAPVox"))
# retrieve 'min_corner' parameter
getMinCorner(vox)
}
