% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{aldex.mem.sim}
\alias{aldex.mem.sim}
\title{Simulation for testing mixed effects models.}
\usage{
aldex.mem.sim(
  D,
  days,
  subjects,
  depth = 10000,
  location = 1,
  random_slope = FALSE,
  corr = 0,
  rho_ar1 = 0,
  sd_resid = 0.1
)
}
\arguments{
\item{D}{number of taxa/genes}

\item{days}{num days (i.e., repeated measurements) for each subject}

\item{subjects}{num of subjects to simulate}

\item{depth}{sum of counts for each multinomial draw}

\item{location}{second random intercept, if 0 ignore, else
simulate num of locations}

\item{random_slope}{If true, simulate a random slope for each
subject.}

\item{corr}{The correlation between slope/random intercept}

\item{rho_ar1}{The ar1 time-correlation, if 0, don't simulate}

\item{sd_resid}{The residual error
time-correlation.}
}
\description{
Includes random intercpt, option to include random slope, second
random intercept, and time-correlation.
}
\author{
Kyle McGovern
}
