% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisy.R
\name{lisy}
\alias{lisy}
\title{Linear Syllogism Generator}
\usage{
lisy(seed = 1, nclues = 4, nspread = 5, clone = NULL,
  incidental = "names", linear = FALSE, antonym = "both", ninfer = 1,
  direct = "ob", Ndist = 4, dist = "mixed", distprob = 0.5,
  itemSet = "random", items = NULL, scales = NULL)
}
\arguments{
\item{seed}{Generates the same question again from local computer.}

\item{nclues}{Generates the number of sentences to make up the item.}

\item{nspread}{Calculates the spread of possible incidentals in total.}

\item{clone}{Null means that every generated item may or may not have a different position in the inference. If given a numeric value, then the items will have the same inference position.}

\item{incidental}{Tells the function whether the item features are 'names' or 'objects'.}

\item{linear}{If linear = TRUE, a matching operator(i.e. name or object) will appear in all the adjacent clues in the sentence.}

\item{antonym}{Determine whether to use both antonyms ('both') or only one type ("first" or "second").}

\item{ninfer}{Generate answers that requires a X amount of inference from the items. Up to 3 is the maximum.}

\item{direct}{Deciding on whether the clues are organised in an ordered("of" = ordered forward / "ob" = ordered backward) or unordered ('alt' = alternative) fashion. Note. 'alt' can only be used when ninfer is 3 or greater.}

\item{Ndist}{Returns the number of distractors per question.}

\item{dist}{Select the type of distractors. You have three options ('mixed', 'invalid','false'). If dist='false', then the number of false distractors must be less than the number of clues by 1.}

\item{distprob}{Calculates the number of comparison variation for the distractors.}

\item{itemSet}{This is the choice of itemset you want. If itemSet='random' then the generator will randomly select one ('People', 'Fruits', 'Superheroes'). Change itemset='own' if you are using your own item set.}

\item{items}{Input own item type. At least 10 items. Default items are used when items = NULL.}

\item{scales}{Input own antonyms. At least 2 antonyms (i.e."bigger","smaller"). Default antonyms are used when scales = NULL.}
}
\description{
This function generates linear syllogistic reasoning items. This is for research purposes.
}
\details{
There are several things to note. To use own item set, please have at least 10 items within the itemset. In order for antonyms comparison to work, please ensure that you have at least 2 antonyms The function will stop if the criteria is not met. The genearation of items are slower if you have a huge item set (e.g. In the millions!).

When nspread and nclue is = 3. This means that there are 3 sentences, and only 3 names. This makes it impossible to generate an invalid distractor. As such, only the false distractors will be created. Since there are only three clues, then at most 2 false distractors can be created.
When nspread and nclues are the same, all the names of the invalid distractors will be taken from the names that are used in the clues. As nspread value increases, the likelihood of having names not taken from the clues increases. Making the distractors fairly easy as there is a higher likelihood that the names taken from the matrix might not appear in the clues. Hence, keeping the value of nspread and nclue as close as possible is recommended.


This function only generates items that requires up to 3 inferences. As the required inferences increases, then number of clues needed also increases. Inference is the implied comparison between sentences which allows the test taker to make an inform decision. When ninfer = 1 and the antonym is declared as either 'first' or 'second', then the correct answer will always be the opposite of the antonym used in the sentence. When ninfer = 2, the correct answer will be in the right direction.

Direct is the direction of the line of thought. If direct = "ob" it means that solving the items requires the test taker to work 'ordered backward'. If it is 'of', it means 'ordered  forward' and finally if it is 'alt', then it means the clues are not in order. direct = 'alt' can only be used when ninfer = 3.

When linear = FALSE, there might be a possible of having just a single mental model, or having completing models. This is random and will depend on the seed selected.

When linear = TRUE, the direct and antonym position follow together. i.e. If direct = "of" and antonym = "first". The antonym will be the same for the question and the answer. Same when direct = "of" and antonym = "second". In such suitation, the names will follow in a linear sequence (A > B, B > C, C > D). However, when direct is changed to "ob",  then the sentence structure changes to becomes (C > D, B > C, A > B). For both situations, this is directly looking at the difficulty of mental array. Under such circumstances, 2 answers will be generated. Either one is correct, but they are the inverse antonym of each other. When direct = "both", the names will most likely not follow a linear sequence, and the antonyms will interchange between sentence (i.e. A > B, C > B, C < E).

When linear = TRUE and infer = 3, the last sentence will always not be one of the clues for the inference. If you want to study distance effect, then what is recommended is to generate the items with ninfer = 3, and remove the last clues in the sentence structure.

When distprob = 0.5, the distribution of the antonym for the distractors will be mixed. When distprob is either 1 or 0, then only one of the two antonym will be used. This is only used if one wishes to study distractor analysis.
}
\examples{
#Generate an item with default item set
lisy(seed=10,nclues=4,nspread=6,clone = NULL,incidental='names',linear=FALSE,
    antonym="first",ninfer = 3, direct='ob', Ndist=3,
    dist="mixed",distprob=0.5,itemSet='random',
    items= NULL,scales = NULL)

#Item set
superheroes <- c('Spider man','Super man','Batman','Wolverine',
'Catwoman','Thor','The Shadow','Silver Surfer', 'Flash','Wonder woman',
'Mr. Fantastic', 'Aqua man', "Hawkeye", 'Starfire', 'Venom', "General Zod")

#Antonym
compare <- c("taller","shorter", "older", "younger",
 "smaller", "bigger","stronger", "weaker")

#Generate item with own dataset
lisy(seed=1,nclues=4,nspread=6,clone = NULL,incidental='names',linear=FALSE,
    antonym="first",ninfer = 3, direct='ob',
    Ndist=3, dist="mixed",distprob=0.5,
    itemSet='own',items= superheroes, scales = compare)

#loop through 30 items
run <- NULL
for(i in 1:30){
 run[[i]]<-AIG::lisy(seed=i,nclues=4,nspread=5,clone = 1,incidental='names',linear=TRUE,
                     dist="false",distprob=0.5,itemSet='random',
                     antonym="both",ninfer = 3, direct='of', Ndist=3,
                    items= NULL,scales = NULL)
}
}
\references{
Leth-Steensen, C., & Marley, A. A. J. (2000). A model of response time effect in symbolic comparison. \emph{Psychological Review, 107}, 62-100.

Sternberg, R. J. (1980). Representation and process in linear syllogistic reasoning. Journal of Experimental Psychology: General, 109(2), 119.

Sedek, G., & Von Hecker, U. (2004). Effects of subclinical depression and aging on generative reasoning about linear orders: Same or different processing limitations?. \emph{Journal of Experimental Psychology: General, 133(2)}, 237.
}
\seealso{
\code{\link{arith}}, \code{\link{spatial2d}}, \code{\link{spatial3d}}
}
\author{
Aiden Loe and Francis Smart
}
