% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gt3x_dev_external_compare.R
\name{dev_external_compare}
\alias{dev_external_compare}
\title{Verify \code{\link{read_gt3x}} gives equivalent output using dev and
external parsers}
\usage{
dev_external_compare(file, time = FALSE, verbose = FALSE)
}
\arguments{
\item{file}{path to the gt3x file for use in comparing the parsers}

\item{time}{logical. Should timing information be returned?}

\item{verbose}{logical. Print updates to console?}
}
\value{
If \code{time = FALSE} (default), a logical scalar is returned,
  indicating whether the outputs matched. If \code{time = TRUE}, run times
  are returned for both parsers.
}
\description{
Verify \code{\link{read_gt3x}} gives equivalent output using dev and
external parsers
}
\note{
This is intended to be run after verifying that output from the dev
  parser matches the legacy parser (see \code{\link{legacy_dev_compare}}).
  The latter is very slow, so this setup allows only having to run it once.
}
\examples{
\donttest{
file_3x <- system.file(
  "extdata", "example.gt3x", package = "AGread"
)
dev_external_compare(file_3x)
}
}
