% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_packet_set_ACTIVITY2.R,
%   R/parse_packet_set_CAPSENSE&METADATA.R, R/parse_packet_set_EVENT.R,
%   R/parse_packet_set_SENSOR_DATA.R, R/parse_packet_set_SENSOR_SCHEMA.R,
%   R/parse_packet_set__generic_&_simple_methods.R
\name{parse_packet_set.ACTIVITY2}
\alias{parse_packet_set.ACTIVITY2}
\alias{capsense_payload}
\alias{parse_packet_set.CAPSENSE}
\alias{parse_packet_set.METADATA}
\alias{parse_packet_set.EVENT}
\alias{parse_packet_set.SENSOR_DATA}
\alias{parse_packet_set.SENSOR_SCHEMA}
\alias{parse_packet_set}
\alias{parse_packet_set.default}
\alias{parse_packet_set.ACTIVITY}
\alias{parse_packet_set.PARAMETERS}
\alias{parse_packet_set.BATTERY}
\title{Parse all packets of a given type}
\usage{
\method{parse_packet_set}{ACTIVITY2}(set, log, tz = "UTC", verbose = FALSE, info, events, ...)

capsense_payload(payload)

\method{parse_packet_set}{CAPSENSE}(set, log, tz = "UTC", verbose = FALSE, ...)

\method{parse_packet_set}{METADATA}(set, log, tz = "UTC", verbose = FALSE, payload = NULL, ...)

\method{parse_packet_set}{EVENT}(set, log, tz = "UTC", verbose = FALSE, info, ...)

\method{parse_packet_set}{SENSOR_DATA}(
  set,
  log,
  tz = "UTC",
  verbose = FALSE,
  parameters,
  schema,
  ...
)

\method{parse_packet_set}{SENSOR_SCHEMA}(set, log, tz = "UTC", verbose = FALSE, payload = NULL, ...)

parse_packet_set(set, log, tz = "UTC", verbose = FALSE, ...)

\method{parse_packet_set}{default}(set, log, tz = "UTC", verbose = FALSE, ...)

\method{parse_packet_set}{ACTIVITY}(set, log, tz = "UTC", verbose = FALSE, ...)

\method{parse_packet_set}{PARAMETERS}(set, log, tz = "UTC", verbose = FALSE, ...)

\method{parse_packet_set}{BATTERY}(set, log, tz = "UTC", verbose = FALSE, ...)
}
\arguments{
\item{set}{the set of record headers corresponding to each packet}

\item{log}{the raw data from \code{log.bin}}

\item{tz}{character. The timezone to use}

\item{verbose}{logical. Print updates to console?}

\item{info}{the result of \code{\link{parse_info_txt}}}

\item{events}{the result of parsing EVENTS packets
(internal use)}

\item{...}{further arguments passed to methods}

\item{payload}{a raw vector containing packet payload}

\item{parameters}{A PARAMETERS object}

\item{schema}{A SENSOR_SCHEMA object}
}
\value{
A list of packet information
}
\description{
Parse all packets of a given type
}
\keyword{internal}
