% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lux.R, R/read_gt3x_bin_dev_packets.R,
%   R/read_gt3x_bin_dev_packets_map.R
\name{get_lux}
\alias{get_lux}
\alias{set_packet_class}
\alias{get_parameters}
\alias{get_schema}
\alias{get_events}
\alias{get_activity}
\alias{get_activity2}
\alias{get_sensor_data}
\alias{get_battery}
\alias{get_capsense}
\alias{get_metadata}
\alias{get_default_packet}
\alias{dev_bin1_map_packets}
\title{Parse gt3x packets using the dev scheme}
\usage{
get_lux(packets, tz, info, verbose)

set_packet_class(packets, label)

get_parameters(packets, tz, verbose)

get_schema(packets, tz, verbose)

get_events(packets, tz, info, verbose)

get_activity(packets, tz, info, verbose)

get_activity2(packets, tz, info, verbose)

get_sensor_data(packets, schema, parameters, tz, info, verbose)

get_battery(packets, tz, verbose)

get_capsense(packets, tz, verbose)

get_metadata(packets, tz, verbose)

get_default_packet(type)

dev_bin1_map_packets(type, packets, tz, info, verbose)
}
\arguments{
\item{packets}{object containing data packets or subsequently parsed data}

\item{tz}{character. The timezone to use}

\item{info}{result of \code{\link{read_gt3x_info}}}

\item{verbose}{logical. Print updates to console?}

\item{label}{character. The desired class name for parsed packet data of a
given type}

\item{schema}{parsed sensor schema information}

\item{parameters}{parsed parameters information}

\item{type}{character. The packet type}
}
\description{
Parse gt3x packets using the dev scheme
}
\keyword{internal}
