% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gt3x.R
\name{read_gt3x}
\alias{read_gt3x}
\title{Read data from a gt3x file}
\usage{
read_gt3x(file, tz = "UTC", verbose = FALSE, include = c("METADATA",
  "PARAMETERS", "SENSOR_SCHEMA", "BATTERY", "EVENT", "TAG", "ACTIVITY",
  "HEART_RATE_BPM", "HEART_RATE_ANT", "HEART_RATE_BLE", "LUX", "CAPSENSE",
  "EPOCH", "EPOCH2", "EPOCH3", "EPOCH4", "ACTIVITY2", "SENSOR_DATA"))
}
\arguments{
\item{file}{character. Path to the file}

\item{tz}{character. The timezone to use}

\item{verbose}{logical. Print updates to console?}

\item{include}{character. The PACKET types to parse}
}
\value{
A list of processed data, with one element for each of the relevant
  packet types.
}
\description{
Read data from a gt3x file
}
\details{
The default value for \code{include} gives all possible packet types, of
which there are 18. Processing time can be reduced by passing a subset of the
18 possibilities. Exclusion is not recommended for the PARAMETERS and
SENSOR_SCHEMA packets, which also do not take long to process.
}
\examples{
\donttest{
file_3x <- system.file(
  "extdata", "example.gt3x", package = "AGread"
)
AG_3x <- read_gt3x(file_3x)
head(lapply(AG_3x, head))
}

}
\references{
\url{https://github.com/actigraph/GT3X-File-Format}
}
