% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImage.R
\name{invertBinaryAFMImage}
\alias{invertBinaryAFMImage}
\title{invert a binary AFMImage}
\usage{
invertBinaryAFMImage(AFMImage)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\value{
an \code{\link{AFMImage}}
}
\description{
\code{invertBinaryAFMImage} returns a binary AFMImage
}
\examples{
\dontrun{
library(AFM)
data(AFMImageOfAluminiumInterface)
newAFMImage<-copy(AFMImageOfAluminiumInterface)
displayIn3D(newAFMImage,noLight=TRUE)
newAFMImage<-multiplyHeightsAFMImage(newAFMImage, multiplier=2)
displayIn3D(newAFMImage,noLight=TRUE)
newAFMImage<-filterAFMImage(newAFMImage,  Min=140, Max=300)
displayIn3D(newAFMImage,noLight=TRUE)
newAFMImage<-makeBinaryAFMImage(newAFMImage)
displayIn3D(newAFMImage,noLight=TRUE)
newAFMImage<-invertBinaryAFMImage(newAFMImage)
displayIn3D(newAFMImage,noLight=TRUE)
}
}
\author{
M.Beauvais
}
