% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findFd.R
\name{findFd}
\alias{findFd}
\title{Find f(x) and delta(x) from a Data Set}
\usage{
findFd(dat, h = NULL, dmethod = "euclidean", htype = "AMISE",
  fdelta = "mnorm", verbose = FALSE)
}
\arguments{
\item{dat}{a numeric matrix where rows are samples and columns are features.}

\item{h}{nonnegative number or NULL (default). Bandwidth in density estimation. If NULL h is automatically selected.}

\item{dmethod}{character string describing distance measures to use in dist(.. method = dmethod).}

\item{htype}{integer vector. Number of clusters. Default = 5.}

\item{fdelta}{character string that specifies the method to estimate densities at each data point. Default is "mnorm" stands for multivariate Gaussian density estimation. Other options include}

\item{verbose}{if TRUE progress will be displayed.#'}
}
\value{
an R object with class "rd". If length(h) = 1 then "rd" is a list of 
the following items:
\itemize{
\item f: vector of f's
\item delta: vector of delta's
\item dat: the original data matrix
\item distm: distance matrix calculated from data (Euclidean distance))
\item dc: bandwith dc.
}
If h == NULL, then the function returns a list of length 15, where each 
item is a list corresponding to one h value.
}
\description{
This function finds f(x) and delta(x) of each point x, where f(x) is 
the density estimation at each point, and delta(x) measures the 
distance between x to the closest point y such that f(y) > f(x). 
The output is used in 'findCluster()' and 'findClusterAuto()'.
}
\examples{
## data(clust3)
##findFd(clust3, h = 19, plot = TRUE)
}

