% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADP.R
\name{pusers}
\alias{pusers}
\title{Calculates the predicted prevalence of users according to the triers' rate}
\usage{
pusers(triers)
}
\arguments{
\item{triers}{a vector of percentage (0<triers<1) of known triers}
}
\value{
a vector of predicted percentage (0<users<1) of users in the population of a certain innovation according to known triers rate
}
\description{
This function develops a prediction of the users' rate of an innovation in
the market, according to the number of triers
}
\details{
This function calculates the rate of users in the population of a certain
innovation according to known triers rate in that population and measured in a survey.

The measuring of triers is relatively easy. It is just a question of whether
a person tried a product even once in his life or not. While measuring the
rate of people who also adopt it as part of their life is more complicated
since the adoption of a product is a subjective view of the individual.
Mickey Kislev and Shira Kislev developed a formula to calculates the prevalence
of users of a product to overcome this difficulty. The current function
assists in calculating the users of a product based on the prevalence of
triers in the population.
}
\examples{
# 50\% rate of triers
pusers(0.5)
0.2455041
# means that 24.5\% of the population uses the product regularly
}
\references{
Kislev, Mickey M. & Kislev, Shira, (2020). The Market Trajectory of a
Radically New Product: E-Cigarettes. IJMS 12(4):63-92, DOI:\href{https://www.ccsenet.org/journal/index.php/ijms/article/view/0/44285}{10.5539/ijms.v12n4p63}
}
\seealso{
\code{\link{ptriers}}, \code{\link{adp.t}}, and \code{\link{adp.u}}
}
\author{
Mickey Kislev and Shira Kislev
}
