% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSigMatrix.R
\name{plotKappas}
\alias{plotKappas}
\title{Plot condition numbers}
\usage{
plotKappas(
  kappas,
  nGenes,
  smData = NULL,
  titleStr = "Shrink Signature Matrix",
  bonusPoints = NULL,
  maxCond = 100
)
}
\arguments{
\item{kappas}{The condition numbers to plot}

\item{nGenes}{The number of genes associated with each kapp}

\item{smData}{Smoothed data to plot as a green line (DEFAULT: NULL)}

\item{titleStr}{The title of the plot (DEFAULT: 'Shrink Signature Matrix')}

\item{bonusPoints}{Set to plot additional points on the plot, see description (DEFAULT: NULL)}

\item{maxCond}{Cap the condition number to maxCond (DEFAULT: 100)}
}
\value{
a matrix including imputed values
}
\description{
Plot the condition numbers during the growing and shrinking of signature matrices.

   bonusPoints <- data.frame(legText = c('Unagumented Signature Matrix', 'Minimum Smoothed Condition Number', 'Best Augmented Signature Matrix'), 
                               pchs = c('o', 'x', 'x'), 
                               cols = c('red', 'purple', 'blue'), 
                               kappa = c(10, 15, 20), 
                               nGene = c(5, 10, 15))
}
\examples{
nGenes <- 1:300
kappas <- log(abs(nGenes-250))
kappas[is.infinite(kappas)] <- 0
kappas <- kappas+runif(300, 0, 1)
smData <- stats::smooth(kappas)
bonusPoints <- data.frame(legText = 'Minimum Smoothed ', pchs='x', cols='purple', 
kappa=min(smData), nGenes=nGenes[which.min(smData)])
plotKappas(kappas=kappas, nGenes=nGenes, smData=smData, bonusPoints=bonusPoints, maxCond=100)

}
