% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bloodcontrol}
\alias{bloodcontrol}
\title{Blood samples from different athletes.}
\format{A data frame with 13 rows and 12 haematological variables:
\describe{
  \item{HCT}{Haematocrit [\%]}
  \item{HGB}{Haemoglobin [g/dl]}
  \item{IRF}{Immature reticulocyte fraction [\%]}
  \item{MCH}{Mean corpuscular haemoglobin pg}
  \item{MCHC}{Mean corpuscular haemoglobin concentration g/dl}
  \item{MCV}{Mean corpuscular volume [fL]}
  \item{RBC}{Eed blood cell count 10^6/ul}
  \item{RDW.SD}{Red blood cell distribution width [fL]}
  \item{RETC}{Reticulocyte count 10^6/ul}
  \item{RETP}{Reticulocyte percentage \%}
  \item{OFFscore}{Off-score}
  \item{ABPS}{Abnormal blood profile score}
}

Based on the values, there is no indication that these athletes
were doped.}
\source{
Swiss Laboratory for Doping Analyses (LAD), with some calculations
performed by the World Anti-Doping Agency (WADA).
}
\usage{
bloodcontrol
}
\description{
A dataset containing the result of the analysis of 13 blood samples
from different athletes.
}
\section{Note}{
 One of the rows does not actually belong to an
    athlete, but to one of the authors of this package, who promises
    that he was not doped.
}

\keyword{datasets}
