\name{grid.grep}
\alias{grid.grep}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Search for Grobs and/or Viewports
}
\description{
  Given a path, find all matching grobs and/or viewports on the display list
  or within a given grob.
}
\usage{
grid.grep(path, x = NULL, grobs = TRUE, viewports = FALSE,
          strict = FALSE, grep = FALSE, global = FALSE,
          no.match = character(), vpPath = viewports)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{path}{ a gPath or a vpPath or a character value that could be
    interpreted as either. }
  \item{x}{ a grob or \code{NULL}.  If \code{NULL}, the display list
    is searched.
  }
  \item{grobs}{A logical value indicating whether to search for grobs.}
  \item{viewports}{A logical value indicating whether to search for
    viewports.}
  \item{strict}{
    A boolean indicating whether the \code{path} must be matched
    exactly.
  }
  \item{grep}{
    Whether the \code{path} should be treated as a regular expression.
  }
  \item{global}{
    A boolean indicating whether the function should affect just the
    first match of the \code{path}, or whether all matches should be
    affected.
  }
  \item{no.match}{
    The value to return if no matches are found.
  }
  \item{vpPath}{
    A logical value indicating whether to return the vpPath for each
    grob as an attribute of the result.
  }
}
\value{
  Either a gPath or a vpPath or,
  if \code{global} is \code{TRUE} a list of gPaths and/or vpPaths.

  If \code{vpPath} is \code{TRUE}, each gPath result will have an
  attribute \code{"vpPath"}.
  
  If there are no matches, \code{no.match} is returned.
}

\seealso{
  grid.ls()
}
\examples{
# A gTree, called "grandparent", with child gTree,
# called "parent", with childrenvp vpStack (vp2 within vp1)
# and child grob, called "child", with vp vpPath (down to vp2)
sampleGTree <- gTree(name="grandparent",
                     children=gList(gTree(name="parent",
                          children=gList(grob(name="child", vp="vp1::vp2")),
                          childrenvp=vpStack(viewport(name="vp1"),
                                             viewport(name="vp2")))))
# Searching for grobs
grid.grep("parent", sampleGTree)
grid.grep("parent", sampleGTree, strict=TRUE)
grid.grep("grandparent", sampleGTree, strict=TRUE)
grid.grep("grandparent::parent", sampleGTree)
grid.grep("parent::child", sampleGTree)
grid.grep("[a-z]", sampleGTree, grep=TRUE)
grid.grep("[a-z]", sampleGTree, grep=TRUE, global=TRUE)
# Searching for viewports
grid.grep("vp1", sampleGTree, viewports=TRUE)
grid.grep("vp2", sampleGTree, viewports=TRUE)
grid.grep("vp", sampleGTree, viewports=TRUE, grep=TRUE)
grid.grep("vp2", sampleGTree, viewports=TRUE, strict=TRUE)
grid.grep("vp1::vp2", sampleGTree, viewports=TRUE)
# Searching for both
grid.grep("[a-z]", sampleGTree, viewports=TRUE, grep=TRUE, global=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ dplot }
