\name{buildVignette}
\alias{buildVignette}
\title{Build one vignette}
\description{
  Run \code{\link{Sweave}} (or other custom weave function)
  \code{\link{texi2dvi}}, and/or \code{\link{Stangle}} 
  (or other custom tangle function)  on one vignette.
}
\usage{
buildVignette(file, dir = ".", weave = TRUE, latex = TRUE, tangle = TRUE, 
                  quiet = TRUE, clean = TRUE, engine = NULL, buildPkg = NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{file}{character; the vignette source file}
  \item{dir}{character; the working directory in which the intermediate and 
                 output files will be produced}
  \item{weave}{logical; should weave be run?}
  \item{latex}{logical; \link{texi2pdf} be run if weaving produces a \file{.tex} file?}
  \item{tangle}{logical; should tangle be run?}
  \item{quiet}{logical; run in quiet mode?}
  \item{clean}{logical; whether to remove intermediate files.  See details below.}
  \item{engine}{\code{NULL} or character; name of vignette engine to use.  Overrides
   any  \code{\\VignetteEngine\{\}} markup in the vignette.}
  \item{buildPkg}{\code{NULL} or character; an optional package in which to find
    the vignette engine}
  \item{...}{Additional arguments passed to weave and tangle.}

}
\details{
This function determines the vignette engine for the vignette (default \code{utils::Sweave}), 
then weaves and/or tangles the vignette using that engine.  Finally, if \code{clean} is \code{TRUE},
newly created intermediate files will be deleted.  If \code{clean} is \code{NA}, newly created
\file{.tex} files will not be deleted even if a \file{.pdf} file has been produced from them.

If \code{buildPkg} is specified, it will be loaded before the vignette is processed, and will
be used as the default package 
in the search for a vignette engine, but an explicitly specified package in the vignette source
(e.g. using \code{\\VignetteEngine\{utils::Sweave\}} to specify the \code{Sweave} 
engine in the \pkg{utils} package) will override it.   In contrast, 
if the \code{engine} argument is given, it will override the 
vignette source.
}
\value{
A character vector naming the files that have been produced.
}
\author{
Henrik Bengtsson and Duncan Murdoch
}
\seealso{
\code{\link{buildVignettes}} for building all vignettes in a package.
}
\keyword{documentation}
