% File src/library/tools/man/buildVignettes.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2013 R Core Team
% Distributed under GPL 2 or later

\name{buildVignettes}
\alias{buildVignettes}
\alias{pkgVignettes}
\title{List and Build Package Vignettes}
\description{
  Run \code{\link{Sweave}} (or other custom weave function)
  and \code{\link{texi2dvi}} on all vignettes
  of a package.
}
\usage{
buildVignettes(package, dir, lib.loc = NULL, quiet = TRUE,
               clean = TRUE, tangle = FALSE)

pkgVignettes(package, dir, subdirs = NULL, lib.loc = NULL,
	     output = FALSE, source = FALSE)
}
\arguments{
  \item{package}{a character string naming an installed package.  If
    given, Sweave files are searched in subdirectory \file{doc}.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This subdirectory \file{vignettes} (or if it
    does not exist \file{inst/doc}) is searched for Sweave files.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    search for \code{package}.}
  \item{quiet}{logical. Weave and run
    \code{\link{texi2pdf}} in quiet mode.}
  \item{clean}{Remove all files generated by the build, even if there
    were copies there before.}
  \item{tangle}{logical.  Do tangling as well as weaving.}
  \item{subdirs}{a character vector of subdirectories of \code{dir} in which
    to look for vignettes.  Ignored if \code{package} is used.}
  \item{output}{logical.  If \code{TRUE}, the output filename
    for each vignette in the result.}
  \item{source}{logical.  If \code{TRUE}, include the tangled output filename
    for each vignette in the result.}
}
\details{
  \code{buildVignettes} is used by \code{R CMD build} and \code{R CMD
    check} to (re-)build vignette PDFs from their (typically Sweave) sources.
}
\value{
  \code{buildVignettes} is called for its side effect of creating the
  PDF versions of all vignettes, and if \code{tangle = TRUE}, 
  extracting the \R{} code.

  \code{pkgVignettes} returns an object of class \code{"pkgVignettes"}
  if a vignette directory is found, otherwise \code{NULL}.  
}
\keyword{utilities}
\keyword{documentation}
