% File src/library/grDevices/man/unix/x11.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Development Team
% Distributed under GPL 2 or later

\name{x11}
\alias{x11}
\alias{X11}
\title{X Window System Graphics}
\description{
  \code{X11} starts a graphics device driver for the X Window System
  (version 11).  This can only be done on machines that run X.
  \code{x11} is recognized as a synonym for \code{X11}.
}
\usage{
X11(display = "", width = 7, height = 7, pointsize = 12,
    gamma = getOption("gamma"), colortype = getOption("X11colortype"),
    maxcubesize = 256, bg = "transparent", canvas = "white",
    fonts = getOption("X11fonts"), xpos = NA, ypos = NA)
}
\arguments{
  \item{display}{the display on which the graphics window will appear.
    The default is to use the value in the user's environment variable
    \env{DISPLAY}.}
  \item{width, height}{the width and height of the plotting window, in
    inches.  See also Resources.}
  \item{pointsize}{the default pointsize to be used.}
  \item{gamma}{the gamma correction factor.  This value is used
    to ensure that the colors perceived are linearly related to
    RGB values (see \code{\link{hsv}}).  By default this is taken from
    \code{\link{options}("gamma")}, or is 1 (no correction) if that is
    unset (which is the usual case). }
  \item{colortype}{the kind of color model to be used.  The
    possibilities are \code{"mono"}, \code{"gray"}, \code{"pseudo"},
    \code{"pseudo.cube"} and \code{"true"}.  Ignored if an \code{X11}
    device is already open.}
  \item{maxcubesize}{can be used to limit the size of color
    cube allocated for pseudocolor devices.}
  \item{bg}{color.  The default background color.}
  \item{canvas}{color.  The color of the canvas, which is visible only
    when the background color is transparent.}
  \item{fonts}{X11 font description strings into which weight, slant and
    size will be substituted.  There are two, the first for fonts 1 to 4
    and the second for font 5, the symbol font. See section Fonts.}
  \item{xpos, ypos}{initial position of the top left corner of the
    window, in pixels.  Negative values are from the opposite corner,
    e.g. \code{xpos=-100} says the top right corner should be 100 pixels
    from the right edge of the screen.
    If \code{NA}, successive devices are cascaded in
    20 pixel steps from the top left.  See also Resources.}
}
\details{
  By default, an X11 device will use the best color rendering
  strategy that it can.  The choice can be overridden with the
  \code{colortype} parameter.  A value of \code{"mono"} results in
  black and white graphics, \code{"gray"} in grayscale and
  \code{"true"} in truecolor graphics (if this is possible).  The
  values \code{"pseudo"} and \code{"pseudo.cube"} provide color
  strategies for pseudocolor displays.  The first strategy provides
  on-demand color allocation which produces exact colors until
  the color resources of the display are exhausted.  The second
  causes a standard color cube to be set up, and requested colors
  are approximated by the closest value in the cube.  The default
  strategy for pseudocolor displays is \code{"pseudo"}.

  \bold{Note:} All \code{X11} devices share a \code{colortype} which is
  set by the first device to be opened.  To change the \code{colortype}
  you need to close \emph{all} open \code{X11} devices then open one
  with the desired \code{colortype}.

  With \code{colortype} equal to \code{"pseudo.cube"} or \code{"gray"}
  successively smaller palettes are tried until one is completely
  allocated. If allocation of the smallest attempt fails the device will
  revert to \code{"mono"}.

  Line widths as controlled by \code{par(lwd=)} are in multiples of the
  pixel size, and multiples < 1 are silently converted to 1.

  \code{pch="."} with \code{cex = 1} corresponds to a rectangle of sides
  the larger of one pixel and 0.01 inch.

  The initial size and position are only hints, and may not be acted on
  by the window manager.
}
\section{Fonts}{
  An initial/default font family for the device can be specified via
  the \code{fonts} argument, but if a device-independent R graphics font
  family is specified (e.g., via \code{par(family=)} in the graphics
  package), the X11 device makes use of the X11 font database (see
  \code{X11Fonts}) to convert the R graphics font family to an
  X11-specific font family description.

  X11 chooses fonts by matching to a pattern, and it is quite possible
  that it will choose a font in the wrong encoding or which does not
  contain glyphs for the your language (particularly common in
  \code{iso10646-1} fonts.
  
  The \code{fonts} argument is a two-element character vector, and the
  first element will be crucial in successfully using
  non-Western-European fonts.  Settings that have proved useful include

  \code{"-*-mincho-\%s-\%s-*-*-\%d-*-*-*-*-*-*-*"} for CJK languages and
  \code{"-cronyx-helvetica-\%s-\%s-*-*-\%d-*-*-*-*-*-*-*"} for Russian.

  For UTF-8 locales, the \code{XLC_LOCALE} databases provide mappings
  between character encodings, and you may need to add an entry for your
  locale (e.g. Fedora Core 3 lacks one for \code{ru_RU.utf8}).
}
\section{Resources}{
  The standard X11 resource \code{geometry} can be use to specify the
  window position and/or size, but will be overridden by values
  specified as arguments.  The class looked for is \code{R_x11}. Note
  that the resource specifies the width and height in pixels and not in
  inches.
}

\seealso{
  \code{\link{Devices}},\code{\link{X11Fonts}}.
}
\keyword{device}
