\name{image}
\title{Display a Color Image}
\usage{
image(x, y, z, zlim, col = heat.colors(12),
      add = FALSE, xaxs = "i", yaxs = "i", xlab, ylab, \dots)
}
\alias{image}
\arguments{
  \item{x,y}{locations of grid lines at which the values in \code{z} are
    measured.  These must be in ascending order.  By default, equally
    spaced values from 0 to 1 are used.  If \code{x} is a \code{list},
    its components \code{x$x} and \code{x$y} are used for \code{x}
    and \code{y}, respectively. If the list has component \code{z} this
    is used for \code{z}.}
  \item{z}{a matrix containing the values to be plotted (\code{NA}s are
    allowed).  Note that \code{x} can be used instead of \code{z} for
    convenience.}
  \item{zlim}{the minimum and maximum \code{z} values for which colors
    should be plotted.  Each of the given colors will be used to color an
    equispaced interval of this range. The \emph{midpoints} of the
    intervals cover the range, so that values just outside the range
    will be plotted.}
  \item{col}{a list of colors such as that generated by
    \code{\link{rainbow}}, \code{\link{heat.colors}},
    \code{\link{topo.colors}}, \code{\link{terrain.colors}} or similar
    functions.}
  \item{add}{logical; if \code{TRUE}, add to current plot (and disregard
    the following arguments).  This is rarely useful because
    \code{image} ``paints'' over existing graphics.}
  \item{xaxs, yaxs}{style of x and y axis.  The default \code{"i"} is
    appropriate for images.  See \code{\link{par}}.}
  \item{xlab, ylab}{each a character string giving the labels for the x and
    y axis.  Default to the `call names' of \code{x} or \code{y}, or to
    \code{""} if these where unspecified.}
  \item{\dots}{graphical parameters for \code{\link{plot}} may also be
    passed as arguments to this function.}
}
\description{
  Creates a grid of colored or gray-scale rectangles with colors
  corresponding to the values in \code{z}.  This can be used to display
  three-dimensional or spatial data aka ``images''.

  The functions \code{\link{heat.colors}}, \code{\link{terrain.colors}}
  and \code{\link{topo.colors}} create heat-spectrum (red to white) and
  topographical color schemes suitable for displaying ordered data, with
  \code{n} giving the number of colors desired.
}
\details{
    The length of \code{x} should be equal to the \code{nrow(x)+1} or
    \code{nrow(x)}. In the first case \code{x} specifies the boundaries
    between the cells: in the second case \code{x} specifies the
    midpoints of the cells. Similar reasoning applies to \code{y}. It
    probably only makes sense to specify the midpoints of an
    equally-spaced grid. If you specify just one row or column and a
    length-one \code{x} or \code{y}, the whole user area in the
    corresponding direction is filled.
}
\note{
  Based on a function by Thomas Lumley
  \email{thomas@biostat.washington.edu}.

  The way in which \code{zlim} is divided into colours will be changed
  for the next major release (1.1.0) to divide the range into
  equal-length intervals.
}
\seealso{
  \code{\link{contour}},
  \code{\link{heat.colors}}, \code{\link{topo.colors}},
  \code{\link{terrain.colors}}, \code{\link{rainbow}},
  \code{\link{hsv}}, \code{\link{par}}.
}
\examples{
\testonly{
## Degenerate, should still work
image(as.matrix(1))
image(matrix(pi,2,4))
}
x <- y <- seq(-4*pi, 4*pi, len=27)
r <- sqrt(outer(x^2, y^2, "+"))
image(z = z <- cos(r^2)*exp(-r/6), col=gray((0:32)/32))
image(z, axes=F, main="Math can be beautiful ...",
      xlab=expression(cos(r^2) * e^{-r/6}))
contour(z, add=T, drawlabels=F)

data(volcano)
x <- 10*(1:nrow(volcano))
y <- 10*(1:ncol(volcano))
image(x, y, volcano, col = terrain.colors(100), axes = FALSE)
contour(x, y, volcano, levels = seq(90, 200, by=5), add = TRUE, col = "peru")
axis(1, at = seq(100, 800, by = 100))
axis(2, at = seq(100, 600, by = 100))
box()
title(main = "Maunga Whau Volcano", font.main = 4)
}
\keyword{hplot}
\keyword{aplot}
