\name{phones}
\title{The World's Telephones}
\usage{data(phones)}
\alias{phones}
\format{A matrix with 7 rows and 8 columns.
}
\source{AT&T (1961).  The World's Telephones.
}
\description{
  The number of telephones in various regions of the world (in
  thousands).
}
\details{
  The columns of the matrix give the figures for
  a given region, and the rows the figures for a year.

  The regions are: North America, Europe, Asia, South America,
  Oceania, Africa, Central America.
  
  The years are: 1951, 1956, 1957, 1958, 1959, 1960, 1961.
}
\references{
  McNeil, D. R. (1977).  \emph{Interactive Data Analysis.}  New York: Wiley.
}
\examples{
data(phones)
matplot(rownames(phones), phones, type = "b", log = "y",
        xlab = "Year", ylab = "Number of telephones (1000's)")
legend(1951.5, 80000, colnames(phones), col = 1:7, lty = 1:7, pch = rep(21, 7))
title(main = "phones data: log scale for response")
}
\keyword{datasets}
