\name{filled.contour}
\alias{filled.contour}
\title{Level (Contour) Plots}
\usage{
filled.contour(x = seq(0, 1, len = nrow(z)),
               y = seq(0, 1, len = ncol(z)),
               z, xlim = range(x[is.finite(x)]),
               ylim = range(y[is.finite(y)]),
               zlim = range(z[is.finite(z)]),
               levels = pretty(zlim, nlevels), nlevels = 20,
               color.palette = cm.colors,
               col = color.palette(length(levels) - 1),
               plot.title, plot.axes, key.title, key.axes,
               xaxs="i", yaxs="i", las=1, axes=TRUE, ...)
}
\arguments{
 \item{x,y}{locations of grid lines at which the values in \code{z} are
    measured.  These must be in ascending order.  By default, equally 
    spaced values from 0 to 1 are used.  If \code{x} is a \code{list},
    its components \code{x$x} and \code{x$y} are used for \code{x}
    and \code{y}, respectively. If the list has component \code{z} this
    is used for \code{z}.} 
 \item{z}{a matrix containing the values to be plotted (\code{NA}s are
    allowed).  Note that \code{x} can be used instead of \code{z} for  
    convenience.}
 \item{xlim}{x limits for the plot.}
 \item{ylim}{y limits for the plot.}
 \item{zlim}{z limits for the plot.}
 \item{levels}{a set of levels which are used to partition the range
    of \code{z}.  Areas with \code{z} values between consecutive
    levels are painted with the same color.}
 \item{nlevels}{if \code{levels} is not specified, the range of \code{z},
    values is divided into approximately this many levels.}
 \item{color.palette}{a color palette function to be used to assign
    colors in the plot.}
 \item{col}{an explicit set of colors to be used in the plot.
    This argument overrides any palette function specification.}
 \item{plot.title}{statements which add titles the main plot.}
 \item{plot.axes}{statements which draw axes on the main plot.
    This overrides the default axes.}
 \item{key.title}{statements which add titles for the plot key.}
 \item{key.axes}{statements which draw axes on the plot key.
    This overrides the default axis.}
 \item{xaxs}{the x axis style.  The default is to use internal
    labeling.}
 \item{yaxs}{the y axis style.  The default is to use internal
    labeling.}
 \item{las}{the style of labeling to be used.  The default is to
    use horizontal labeling. }
 \item{\dots}{additional graphical parameters.}
}
\description{
    This function produces a contour plot with the areas between
    the contours filled in solid color (Cleveland calls this a
    level plot).  A key showing how the colors map to z values
    is shown to the right of the plot.
}
\references{
  Cleveland, W. S. (1993).
  \emph{Visualizing Data},
  Summit, New Jersey: Hobart.

}
\author{Ross Ihaka.}
\note{
    This function currently uses the \code{layout} function and so
    is restricted to a full page display.  In future it is likely to
    be replaced by a genuine \code{levelplot} function which will
    work in multipanel displays.
}
\seealso{\code{\link{contour}}, \code{\link{palettes}}.}
\examples{
data(volcano)
x <- 10*1:nrow(volcano)
y <- 10*1:ncol(volcano)

filled.contour(x, y, volcano, color = terrain.colors, nlevels = 20,
    plot.title = title(main = "The Topography of Maunga Whau",
    xlab = "Meters North", ylab = "Meters West"),
    plot.axes = { axis(1, seq(100, 800, by = 100))
                  axis(2, seq(100, 600, by = 100)) },
    key.title = title(main="Height (Meters)"),
    key.axes = axis(4, seq(90, 190, by = 10)))
}
\keyword{hplot}
\keyword{aplot}
