C-----------------------------------------------------------------------
C
C  R : A COMPUTER LANGAGE FOR STATISTICAL DATA ANALYSIS
C  COPYRIGHT (C) 1996  ROBERT GENTLEMAN AND ROSS IHAKA
C
C  THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C  IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C  THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
C  (AT YOUR OPTION) ANY LATER VERSION.
C
C  THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
C  BUT WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  SEE THE
C  GNU GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C  YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C  ALONG WITH THIS PROGRAM; IF NOT, WRITE TO THE FREE SOFTWARE
C  FOUNDATION, INC., 675 MASS AVE, CAMBRIDGE, MA 02139, USA.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE BKSLV(T, LDT, N, B, LDB, X, JOB, INFO)
      INTEGER LDT, N, LDB, JOB, INFO
      DOUBLE PRECISION T(LDT,N),B(LDB,N),X(LDB,N)
C
C     BACKSLV IS A SUBROUTINE TO SOLVE TRIANGULAR SYSTEMS OF
C     THE FORM
C
C                   T * X = B
C     OR
C                   TRANS(T) * X = B
C
C     WHERE T IS A TRIANGULAR MATRIX OF ORDER N. HERE TRANS(T)
C     DENOTES THE TRANSPOSE OF THE MATRIX T.  THE SUBROUTINE
C     HANDLES THE MULTIPLE RIGHT-HAND SIDE CASE.  IT IS REALLY
C     JUST A WRAPPER FOR THE LINPACK SUBROUTINE DTRSL.
C
C     ON ENTRY
C
C        T      DOUBLE PRECISION(LDT,N).
C               X CONTAINS THE COEFFICIENT MATRIX OF THE SYSTEM
C               TO BE SOLVED.  ONLY THE ELEMENTS ABOVE OR BELOW
C               THE DIAGONAL ARE REFERENCED.
C
C        LDT    INTEGER
C               LDT IS THE LEADING DIMENSION OF THE ARRAY T.
C
C        
C        N      INTEGER
C               N IS THE ORDER OF THE SYSTEM.
C
C        B      DOUBLE PRECISION(LDB,NB)
C               B CONTAINS THE RIGHT HAND SIDE(S) OF THE SYSTEM.
C
C        NB     INTEGER
C               THE NUMBER OF RIGHT HAND SIDES OF THE SYSTEM.
C
C        JOB    INTEGER
C               JOB SPECIFIES WHAT KIND OF SYSTEM IS TO BE SOLVED.
C               IF JOB IS
C
C                    00   SOLVE T*X=B, T LOWER TRIANGULAR,
C                    01   SOLVE T*X=B, T UPPER TRIANGULAR,
C                    10   SOLVE TRANS(T)*X=B, T LOWER TRIANGULAR,
C                    11   SOLVE TRANS(T)*X=B, T UPPER TRIANGULAR.
C
C     ON RETURN
C
C        X      DOUBLE PRECISION(LDB, NB)
C               CONTAINS THE SOLUTION(S) IF INFO .NE. 0.
C
C        INFO   INTEGER
C               INFO CONTAINS ZERO IF THE SYSTEM IS NONSINGULAR.
C               OTHERWISE INFO CONTAINS THE INDEX OF
C               THE FIRST ZERO DIAGONAL ELEMENT OF T.
C
C     SUBROUTINES AND FUNCTIONS
C
C     LINPACK DTRSL
C     BLAS DAXPY,DCOPY,DDOT
C     FORTRAN MOD
C
C     INTERNAL VARIABLES.
C
      INTEGER J
C
      DO 10 J=1,N
        CALL DCOPY(N, B(1,J), 1, X(1,J), 1)
        CALL DTRSL(T, LDT, N, X(1,J), JOB, INFO)
        IF(INFO .NE. 0) RETURN
   10 CONTINUE
      RETURN
      END
